/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common.delayed;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.ReturnExiledPermanentsEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

public class OnLeaveReturnExiledAbility
extends DelayedTriggeredAbility {
    public OnLeaveReturnExiledAbility() {
        this(Zone.BATTLEFIELD);
    }

    public OnLeaveReturnExiledAbility(Zone zone) {
        super(new ReturnExiledPermanentsEffect(zone), Duration.OneUse);
        this.usesStack = false;
        this.setRuleVisible(false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    protected OnLeaveReturnExiledAbility(OnLeaveReturnExiledAbility ability) {
        super(ability);
    }

    @Override
    public OnLeaveReturnExiledAbility copy() {
        return new OnLeaveReturnExiledAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        return event.getTargetId().equals(this.getSourceId()) && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD;
    }
}

