/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.HashSet;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.hint.Hint;
import mage.abilities.hint.HintUtils;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public enum CardsInOpponentGraveyardCondition implements Condition
{
    SEVEN(7),
    EIGHT(8),
    TEN(10);

    private final int value;
    private final Hint hint;

    private CardsInOpponentGraveyardCondition(int value) {
        this.value = value;
        this.hint = new CardsInOpponentGraveyardConditionHint(value);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return game.getOpponents(source.getControllerId()).stream().map(game::getPlayer).filter(Objects::nonNull).map(Player::getGraveyard).mapToInt(HashSet::size).anyMatch(i -> i >= this.value);
    }

    public String toString() {
        return "an opponent has " + CardUtil.numberToText(this.value) + " or more cards in their graveyard";
    }

    public Hint getHint() {
        return this.hint;
    }

    private static final class CardsInOpponentGraveyardConditionHint
    implements Hint {
        private final int value;

        private CardsInOpponentGraveyardConditionHint(int value) {
            this.value = value;
        }

        private CardsInOpponentGraveyardConditionHint(CardsInOpponentGraveyardConditionHint hint) {
            this.value = hint.value;
        }

        @Override
        public String getText(Game game, Ability ability) {
            int maxGraveSize = game.getOpponents(ability.getControllerId()).stream().map(game::getPlayer).filter(Objects::nonNull).map(Player::getGraveyard).mapToInt(HashSet::size).max().orElse(0);
            String text = "Opponent graveyard size: " + maxGraveSize + " (need: " + this.value + ")";
            return HintUtils.prepareText(text, null, maxGraveSize >= this.value ? "ICON_GOOD" : "ICON_BAD");
        }

        @Override
        public CardsInOpponentGraveyardConditionHint copy() {
            return new CardsInOpponentGraveyardConditionHint(this);
        }
    }
}

