/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.watchers.common.CastFromHandWatcher;

public enum CastFromHandSourcePermanentCondition implements Condition
{
    instance;


    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        int zccDiff = 0;
        if (permanent == null) {
            permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
            zccDiff = -1;
        }
        if (permanent != null) {
            Spell spell = game.getStack().getSpell(source.getSourceId());
            if ((spell == null || spell.getZoneChangeCounter(game) != permanent.getZoneChangeCounter(game) + zccDiff) && game.getLastKnownInformation(source.getSourceId(), Zone.STACK, permanent.getZoneChangeCounter(game) + zccDiff) == null) {
                return false;
            }
            CastFromHandWatcher watcher = game.getState().getWatcher(CastFromHandWatcher.class);
            if (watcher != null && watcher.spellWasCastFromHand(source.getSourceId())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "you cast it from your hand";
    }
}

