/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public enum DescendCondition implements Condition
{
    FOUR(4),
    EIGHT(8);

    private static final Hint hint;
    private final int amount;

    public static Hint getHint() {
        return hint;
    }

    private DescendCondition(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.getGraveyard().count(StaticFilters.FILTER_CARD_PERMANENT, game) >= this.amount;
    }

    public String toString() {
        return "there are " + CardUtil.numberToText(this.amount) + " or more permanent cards in your graveyard";
    }

    static {
        hint = new ValueHint("Permanent cards in your graveyard", new CardsInControllerGraveyardCount(StaticFilters.FILTER_CARD_PERMANENT));
    }
}

