/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.IntCompareCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DevourEffect;
import mage.abilities.keyword.DevourAbility;
import mage.constants.ComparisonType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class DevouredCreaturesCondition
extends IntCompareCondition {
    public DevouredCreaturesCondition(ComparisonType type, int value) {
        super(type, value);
    }

    @Override
    protected int getInputValue(Game game, Ability source) {
        int devouredCreatures = 0;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            for (Ability ability : sourcePermanent.getAbilities()) {
                if (!(ability instanceof DevourAbility)) continue;
                for (Effect effect : ability.getEffects()) {
                    if (!(effect instanceof DevourEffect)) continue;
                    DevourEffect devourEffect = (DevourEffect)effect;
                    devouredCreatures = devourEffect.getDevouredCreaturesAmount(game, sourcePermanent.getId());
                }
            }
        }
        return devouredCreatures;
    }
}

