/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public enum DifferentManaValuesInGraveCondition implements Condition
{
    FIVE(5);

    private final int amount;

    private DifferentManaValuesInGraveCondition(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.getGraveyard().getCards(game).stream().mapToInt(MageObject::getManaValue).distinct().count() >= (long)this.amount;
    }

    public String toString() {
        return "there are " + CardUtil.numberToText(this.amount) + " or more mana values among cards in your graveyard";
    }
}

