/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.Locale;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.TurnPhase;
import mage.game.Game;

public class IsPhaseCondition
implements Condition {
    protected TurnPhase turnPhase;
    protected boolean yourTurn;

    public IsPhaseCondition(TurnPhase turnPhase) {
        this(turnPhase, false);
    }

    public IsPhaseCondition(TurnPhase turnPhase, boolean yourTurn) {
        this.turnPhase = turnPhase;
        this.yourTurn = yourTurn;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return this.turnPhase == game.getTurnPhaseType() && (!this.yourTurn || game.getActivePlayerId().equals(source.getControllerId()));
    }

    public String toString() {
        return ("during " + (this.yourTurn ? "your " : "") + (Object)((Object)this.turnPhase)).toLowerCase(Locale.ENGLISH);
    }
}

