/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.cards.Card;
import mage.filter.FilterMana;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.util.ManaUtil;

public class OathbreakerOnBattlefieldCondition
implements Condition {
    private final UUID playerId;
    private final FilterControlledPermanent filter;
    private final String compatibleNames;

    public OathbreakerOnBattlefieldCondition(Game game, UUID playerId, UUID signatureSpellId, Set<UUID> oathbreakersToSearch) {
        this.playerId = playerId;
        this.filter = new FilterControlledPermanent("oathbreaker on battlefield");
        Card spell = game.getCard(signatureSpellId);
        FilterMana spellColors = spell != null ? spell.getColorIdentity() : null;
        ArrayList<PermanentIdPredicate> compatibleList = new ArrayList<PermanentIdPredicate>();
        ArrayList<String> compatibleNamesList = new ArrayList<String>();
        if (oathbreakersToSearch != null && !oathbreakersToSearch.isEmpty()) {
            for (UUID id : oathbreakersToSearch) {
                Card commander = game.getCard(id);
                if (commander == null || !ManaUtil.isColorIdentityCompatible(commander.getColorIdentity(), spellColors)) continue;
                compatibleList.add(new PermanentIdPredicate(id));
                compatibleNamesList.add(commander.getName());
            }
        }
        this.compatibleNames = String.join((CharSequence)"; ", compatibleNamesList);
        if (compatibleList.isEmpty()) {
            this.filter.add(new PermanentIdPredicate(UUID.randomUUID()));
        } else {
            this.filter.add(Predicates.or(compatibleList));
        }
    }

    public String getCompatibleNames() {
        return !this.compatibleNames.isEmpty() ? this.compatibleNames : "you haven't compatible oathbreaker";
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int permanentsOnBattlefield = game.getBattlefield().count(this.filter, this.playerId, source, game);
        return permanentsOnBattlefield > 0;
    }

    public String toString() {
        return this.filter.getMessage();
    }
}

