/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.players.Player;

public enum OpponentHasMoreLifeCondition implements Condition
{
    instance;


    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID uuid : game.getOpponents(controller.getId())) {
            Player opponent = game.getPlayer(uuid);
            if (opponent == null || opponent.getLife() <= controller.getLife()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "an opponent has more life than you";
    }
}

