/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;

public class PermanentsOnTheBattlefieldCondition
implements Condition {
    protected final FilterPermanent filter;
    protected final ComparisonType type;
    protected final int count;
    private final boolean onlyControlled;

    public PermanentsOnTheBattlefieldCondition(FilterPermanent filter) {
        this(filter, true);
    }

    public PermanentsOnTheBattlefieldCondition(FilterPermanent filter, boolean onlyControlled) {
        this(filter, ComparisonType.MORE_THAN, 0, onlyControlled);
    }

    public PermanentsOnTheBattlefieldCondition(FilterPermanent filter, ComparisonType type, int count) {
        this(filter, type, count, true);
    }

    public PermanentsOnTheBattlefieldCondition(FilterPermanent filter, ComparisonType type, int count, boolean onlyControlled) {
        this.filter = filter;
        this.type = type;
        this.count = count;
        this.onlyControlled = onlyControlled;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        FilterPermanent localFilter;
        if (this.onlyControlled) {
            localFilter = this.filter.copy();
            localFilter.add(new ControllerIdPredicate(source.getControllerId()));
        } else {
            localFilter = this.filter;
        }
        return ComparisonType.compare(game.getBattlefield().count(localFilter, source.getControllerId(), source, game), this.type, this.count);
    }

    public String toString() {
        return this.filter.getMessage();
    }
}

