/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;

public enum SuspendedCondition implements Condition
{
    instance;


    @Override
    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getSourceId());
        if (card != null) {
            boolean found = card.getAbilities(game).containsClass(SuspendAbility.class);
            if (!found) {
                found = game.getState().getAllOtherAbilities(source.getSourceId()).containsClass(SuspendAbility.class);
            }
            if (found && game.getState().getZone(card.getId()) == Zone.EXILED && card.getCounters(game).getCount(CounterType.TIME) > 0) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "this card is suspended";
    }
}

