/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import mage.abilities.Ability;
import mage.abilities.StaticAbility;
import mage.abilities.costs.AlternativeCost;
import mage.abilities.costs.AlternativeCostImpl;
import mage.abilities.costs.AlternativeSourceCosts;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.constants.AbilityType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public abstract class AlternativeSourceCostsImpl
extends StaticAbility
implements AlternativeSourceCosts {
    protected final AlternativeCost alternativeCost;
    protected final String reminderText;
    protected final String activationKey;

    protected static String getActivationKey(String name) {
        return name + "ActivationKey";
    }

    protected AlternativeSourceCostsImpl(String name, String reminderText, String manaString) {
        this(name, reminderText, new ManaCostsImpl(manaString));
    }

    protected AlternativeSourceCostsImpl(String name, String reminderText, Cost cost) {
        this(name, reminderText, cost, name);
    }

    protected AlternativeSourceCostsImpl(String name, String reminderText, Cost cost, String activationKey) {
        super(Zone.ALL, null);
        this.name = name;
        this.reminderText = reminderText;
        this.alternativeCost = new AlternativeCostImpl(name, reminderText, cost);
        this.activationKey = AlternativeSourceCostsImpl.getActivationKey(activationKey);
    }

    protected AlternativeSourceCostsImpl(AlternativeSourceCostsImpl ability) {
        super(ability);
        this.alternativeCost = ability.alternativeCost.copy();
        this.reminderText = ability.reminderText;
        this.activationKey = ability.activationKey;
    }

    @Override
    public boolean canActivateAlternativeCostsNow(Ability ability, Game game) {
        if (ability == null || !AbilityType.SPELL.equals((Object)ability.getAbilityType())) {
            return this.isActivated(ability, game);
        }
        Player player = game.getPlayer(ability.getControllerId());
        return player != null && this.alternativeCost.canPay(ability, this, player.getId(), game);
    }

    @Override
    public String getAlternativeCostText(Ability ability, Game game) {
        return "Cast with " + this.name + " alternative cost: " + this.alternativeCost.getText(true) + CardUtil.getSourceLogName(game, this);
    }

    @Override
    public boolean activateAlternativeCosts(Ability ability, Game game) {
        this.resetCost();
        ability.setCostsTag(this.activationKey, null);
        this.alternativeCost.activate();
        ability.clearManaCostsToPay();
        ability.clearCosts();
        for (Cost cost : (Costs)((Object)this.alternativeCost)) {
            if (cost instanceof ManaCost) {
                ability.addManaCostsToPay((ManaCost)cost.copy());
                continue;
            }
            ability.addCost(cost.copy());
        }
        return true;
    }

    @Override
    public boolean isActivated(Ability ability, Game game) {
        return CardUtil.checkSourceCostsTagExists(game, ability, this.activationKey);
    }

    @Override
    public Costs<Cost> getCosts() {
        return (Costs)((Object)this.alternativeCost);
    }

    @Override
    public String getRule() {
        return this.alternativeCost.getText(false) + ' ' + this.alternativeCost.getReminderText();
    }

    @Override
    public void resetCost() {
        this.alternativeCost.reset();
    }

    @Override
    public boolean isAvailable(Ability source, Game game) {
        return true;
    }

    @Override
    public String getCastMessageSuffix(Game game) {
        return this.alternativeCost.getCastSuffixMessage(0);
    }
}

