/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import java.io.Serializable;
import mage.abilities.Ability;
import mage.constants.CostModificationType;
import mage.game.Game;

public interface CostAdjuster
extends Serializable {
    default public void prepareX(Ability ability, Game game) {
    }

    default public void prepareCost(Ability ability, Game game) {
    }

    default public void reduceCost(Ability ability, Game game) {
    }

    default public void increaseCost(Ability ability, Game game) {
    }

    default public void modifyCost(Ability ability, Game game, CostModificationType costModificationType) {
        switch (costModificationType) {
            case REDUCE_COST: {
                this.reduceCost(ability, game);
                break;
            }
            case INCREASE_COST: {
                this.increaseCost(ability, game);
                break;
            }
            case SET_COST: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mod type: " + (Object)((Object)costModificationType));
            }
        }
    }
}

