/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCost;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Targets;
import mage.util.CardUtil;

public class OrCost
implements Cost {
    private final List<Cost> costs = new ArrayList<Cost>();
    private String description;
    private Cost selectedCost;

    public OrCost(String description, Cost ... costs) {
        Collections.addAll(this.costs, costs);
        this.description = description;
    }

    protected OrCost(OrCost cost) {
        cost.costs.stream().map(Cost::copy).forEach(this.costs::add);
        this.description = cost.description;
        this.selectedCost = cost.selectedCost;
    }

    @Override
    public UUID getId() {
        throw new RuntimeException("Not supported method");
    }

    @Override
    public OrCost setText(String text) {
        this.description = text;
        return this;
    }

    @Override
    public String getText() {
        return this.description;
    }

    public Cost getSelectedCost() {
        return this.selectedCost;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.costs.stream().anyMatch(cost -> cost.canPay(ability, source, controllerId, game));
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana) {
        return this.pay(ability, game, source, controllerId, noMana, this);
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        this.selectedCost = null;
        List usable = this.costs.stream().filter(cost -> cost.canPay(ability, source, controllerId, game)).collect(Collectors.toList());
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        switch (usable.size()) {
            case 0: {
                return false;
            }
            case 1: {
                this.selectedCost = (Cost)usable.get(0);
                break;
            }
            case 2: {
                StringBuilder sb = new StringBuilder();
                if (usable.get(0) instanceof ManaCost) {
                    sb.append("Pay ");
                    sb.append(((Cost)usable.get(0)).getText());
                } else {
                    sb.append(CardUtil.getTextWithFirstCharUpperCase(((Cost)usable.get(0)).getText()));
                }
                sb.append(" or ");
                sb.append(((Cost)usable.get(1)).getText());
                sb.append('?');
                if (controller.chooseUse(Outcome.Detriment, sb.toString(), null, CardUtil.getTextWithFirstCharUpperCase(((Cost)usable.get(0)).getText()), CardUtil.getTextWithFirstCharUpperCase(((Cost)usable.get(1)).getText()), ability, game)) {
                    this.selectedCost = (Cost)usable.get(0);
                    break;
                }
                this.selectedCost = (Cost)usable.get(1);
                break;
            }
            default: {
                Map costMap = usable.stream().collect(Collectors.toMap(Cost::getText, Function.identity()));
                ChoiceImpl choice = new ChoiceImpl(true);
                choice.setMessage("Choose a cost to pay");
                choice.setChoices(costMap.keySet().stream().map(CardUtil::getTextWithFirstCharUpperCase).collect(Collectors.toSet()));
                controller.choose(Outcome.Neutral, choice, game);
                this.selectedCost = costMap.getOrDefault(CardUtil.getTextWithFirstCharLowerCase(choice.getChoice()), null);
            }
        }
        if (this.selectedCost == null) {
            return false;
        }
        return this.selectedCost.pay(ability, game, source, controllerId, noMana, costToPay);
    }

    @Override
    public boolean isPaid() {
        return this.selectedCost != null ? this.selectedCost.isPaid() : false;
    }

    @Override
    public void clearPaid() {
        this.selectedCost = null;
        this.costs.forEach(Cost::clearPaid);
    }

    @Override
    public void setPaid() {
        if (this.selectedCost != null) {
            this.selectedCost.setPaid();
        }
    }

    @Override
    public Targets getTargets() {
        if (this.selectedCost != null) {
            return this.selectedCost.getTargets();
        }
        return new Targets().withReadOnly();
    }

    @Override
    public OrCost copy() {
        return new OrCost(this);
    }
}

