/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.CostImpl;
import mage.game.Game;
import mage.game.permanent.Permanent;

public abstract class UseAttachedCost
extends CostImpl {
    protected MageObjectReference mageObjectReference;
    protected String name = "{this}";

    protected UseAttachedCost() {
    }

    protected UseAttachedCost(UseAttachedCost cost) {
        super(cost);
        this.mageObjectReference = cost.mageObjectReference;
        this.name = cost.name;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        if (this.mageObjectReference == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(source.getSourceId());
        return permanent != null && permanent.getAttachments().stream().anyMatch(uuid -> this.mageObjectReference.refersTo((UUID)uuid, game));
    }

    public UseAttachedCost setMageObjectReference(Ability source, Game game) {
        this.mageObjectReference = new MageObjectReference(source.getSourceId(), game);
        MageObject object = game.getObject(source);
        if (object != null) {
            this.name = object.getName();
        }
        return this;
    }

    @Override
    public abstract UseAttachedCost copy();
}

