/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCost;
import mage.abilities.costs.VariableCostType;
import mage.abilities.mana.ManaAbility;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.Targets;

public abstract class VariableCostImpl
implements Cost,
VariableCost {
    protected UUID id;
    protected VariableCostType costType;
    protected String text;
    protected boolean paid;
    protected Targets targets;
    protected int amountPaid;
    protected String xText;
    protected String actionText;

    public VariableCostImpl(VariableCostType costType, String actionText) {
        this(costType, "X", actionText);
    }

    public VariableCostImpl(VariableCostType costType, String xText, String actionText) {
        this.id = UUID.randomUUID();
        this.costType = costType;
        this.paid = false;
        this.targets = null;
        this.amountPaid = 0;
        this.xText = xText;
        this.actionText = actionText;
    }

    protected VariableCostImpl(VariableCostImpl cost) {
        this.id = cost.id;
        this.costType = cost.costType;
        this.text = cost.text;
        this.paid = cost.paid;
        this.targets = cost.targets == null ? null : cost.targets.copy();
        this.xText = cost.xText;
        this.actionText = cost.actionText;
        this.amountPaid = cost.amountPaid;
    }

    @Override
    public VariableCostImpl setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getActionText() {
        return this.actionText;
    }

    private void prepareTargets() {
        if (this.targets == null) {
            this.targets = new Targets();
        }
    }

    public void addTarget(Target target) {
        if (target == null) {
            throw new IllegalArgumentException("Wrong code usage: can't add nullable target to the cost");
        }
        this.prepareTargets();
        this.targets.add(target);
    }

    @Override
    public Targets getTargets() {
        this.prepareTargets();
        return this.targets;
    }

    @Override
    public boolean isPaid() {
        return this.paid;
    }

    @Override
    public void clearPaid() {
        this.paid = false;
        this.prepareTargets();
        this.targets.clearChosen();
        this.amountPaid = 0;
    }

    @Override
    public void setPaid() {
        this.paid = true;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana) {
        return this.pay(ability, game, source, controllerId, noMana, this);
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return true;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        return true;
    }

    @Override
    public int getAmount() {
        return this.amountPaid;
    }

    @Override
    public void setAmount(int xValue, int xPay, boolean isPayed) {
        this.amountPaid = xPay;
    }

    @Override
    public int getMinValue(Ability source, Game game) {
        return 0;
    }

    @Override
    public int getMaxValue(Ability source, Game game) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int announceXValue(Ability source, Game game) {
        int xValue = 0;
        Player controller = game.getPlayer(source.getControllerId());
        StackObject stackObject = game.getStack().getStackObject(source.getId());
        if (controller != null && (source instanceof ManaAbility || stackObject != null)) {
            xValue = controller.announceX(this.getMinValue(source, game), this.getMaxValue(source, game), "Announce the value for {X} (" + this.actionText + ")", game, source, false);
        }
        return xValue;
    }

    @Override
    public VariableCostType getCostType() {
        return this.costType;
    }

    @Override
    public void setCostType(VariableCostType costType) {
        this.costType = costType;
    }
}

