/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.awt.Color;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.hint.HintUtils;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

public class CollectEvidenceCost
extends CostImpl {
    private final int amount;
    private final boolean withSource;

    public CollectEvidenceCost(int amount) {
        this(amount, false);
    }

    public CollectEvidenceCost(int amount, boolean withSource) {
        this.amount = amount;
        this.withSource = withSource;
        this.text = "collect evidence " + amount;
    }

    private CollectEvidenceCost(CollectEvidenceCost cost) {
        super(cost);
        this.amount = cost.amount;
        this.withSource = cost.withSource;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return CollectEvidenceCost.getAvailableEvidence(controllerId, game) >= this.amount;
    }

    public static int getAvailableEvidence(UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return 0;
        }
        return player.getGraveyard().getCards(game).stream().filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            this.paid = false;
            return this.paid;
        }
        TargetCard target = new TargetCardInYourGraveyard(1, Integer.MAX_VALUE){

            @Override
            public String getMessage(Game game) {
                int totalMV = this.getTargets().stream().map(game::getCard).filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum();
                return super.getMessage(game) + HintUtils.prepareText(" (selected mana value " + totalMV + " of " + CollectEvidenceCost.this.amount + ")", totalMV >= CollectEvidenceCost.this.amount ? Color.GREEN : Color.RED);
            }
        }.withNotTarget(true);
        target.choose(Outcome.Exile, player.getId(), source.getSourceId(), source, game);
        CardsImpl cards = new CardsImpl((Collection<UUID>)target.getTargets());
        boolean bl = this.paid = cards.getCards(game).stream().filter(Objects::nonNull).mapToInt(MageObject::getManaValue).sum() >= this.amount;
        if (this.paid) {
            if (this.withSource) {
                player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId(game, source), CardUtil.getSourceName(game, source));
            } else {
                player.moveCards(cards, Zone.EXILED, source, game);
            }
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.EVIDENCE_COLLECTED, source.getSourceId(), source, source.getControllerId(), this.amount));
        }
        return this.paid;
    }

    @Override
    public CollectEvidenceCost copy() {
        return new CollectEvidenceCost(this);
    }
}

