/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

public class DiscardTargetCost
extends CostImpl {
    List<Card> cards = new ArrayList<Card>();
    protected boolean randomDiscard;

    public DiscardTargetCost(TargetCardInHand target) {
        this(target, false);
    }

    public DiscardTargetCost(TargetCardInHand target, boolean randomDiscard) {
        this.addTarget(target);
        this.randomDiscard = randomDiscard;
        this.text = "discard " + target.getDescription();
    }

    public DiscardTargetCost(DiscardTargetCost cost) {
        super(cost);
        this.cards.addAll(cost.cards);
        this.randomDiscard = cost.randomDiscard;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        this.cards.clear();
        this.getTargets().clearChosen();
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return false;
        }
        int amount = ((Target)this.getTargets().get(0)).getMinNumberOfTargets();
        if (this.randomDiscard) {
            this.cards.addAll(player.discard(amount, true, true, source, game).getCards(game));
        } else if (this.getTargets().choose(Outcome.Discard, controllerId, source.getSourceId(), source, game)) {
            CardsImpl toDiscard = new CardsImpl();
            toDiscard.addAll(((Target)this.getTargets().get(0)).getTargets());
            Cards discarded = player.discard(toDiscard, true, source, game);
            if (!discarded.isEmpty()) {
                this.cards.addAll(discarded.getCards(game));
            }
        }
        this.paid = this.cards.size() >= amount;
        return this.paid;
    }

    @Override
    public void clearPaid() {
        super.clearPaid();
        this.cards.clear();
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    @Override
    public DiscardTargetCost copy() {
        return new DiscardTargetCost(this);
    }

    public List<Card> getCards() {
        return this.cards;
    }
}

