/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostImpl;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

public class DiscardXTargetCost
extends VariableCostImpl {
    protected FilterCard filter;
    protected boolean isRandom = false;

    public DiscardXTargetCost(FilterCard filter) {
        this(filter, false);
    }

    public DiscardXTargetCost(FilterCard filter, boolean useAsAdditionalCost) {
        super(useAsAdditionalCost ? VariableCostType.ADDITIONAL : VariableCostType.NORMAL, filter.getMessage() + " to discard");
        this.text = (useAsAdditionalCost ? "discard " : "Discard ") + this.xText + ' ' + filter.getMessage();
        this.filter = filter;
    }

    protected DiscardXTargetCost(DiscardXTargetCost cost) {
        super(cost);
        this.filter = cost.filter;
        this.isRandom = cost.isRandom;
    }

    public DiscardXTargetCost withRandom() {
        this.isRandom = true;
        this.text = this.text + " at random";
        return this;
    }

    @Override
    public DiscardXTargetCost copy() {
        return new DiscardXTargetCost(this);
    }

    @Override
    public int getMaxValue(Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            return controller.getHand().count(this.filter, game);
        }
        return 0;
    }

    @Override
    public Cost getFixedCostsFromAnnouncedValue(int xValue) {
        TargetCardInHand target = new TargetCardInHand(xValue, this.filter);
        return new DiscardTargetCost(target, this.isRandom);
    }
}

