/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public class RemoveCountersSourceCost
extends CostImpl {
    private final int amount;
    private final String name;

    public RemoveCountersSourceCost() {
        this.amount = 1;
        this.name = "";
        this.text = "remove a counter from {this}";
    }

    public RemoveCountersSourceCost(int amount) {
        this.amount = amount;
        this.name = "";
        this.text = "remove " + CardUtil.numberToText(amount) + " counters from {this}";
    }

    public RemoveCountersSourceCost(Counter counter) {
        this.amount = counter.getCount();
        this.name = counter.getName();
        this.text = "remove " + counter.getDescription() + " from {this}";
    }

    private RemoveCountersSourceCost(RemoveCountersSourceCost cost) {
        super(cost);
        this.amount = cost.amount;
        this.name = cost.name;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        if (this.name.isEmpty()) {
            return permanent.getCounters(game).values().stream().mapToInt(Counter::getCount).sum() >= this.amount;
        }
        return permanent.getCounters(game).getCount(this.name) >= this.amount;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return this.paid;
        }
        if (this.name.isEmpty()) {
            ArrayList<String> toChoose = new ArrayList<String>(permanent.getCounters(game).keySet());
            if (toChoose.isEmpty()) {
                return this.paid;
            }
            List<Integer> counterList = player.getMultiAmount(Outcome.UnboostCreature, toChoose, 0, this.amount, this.amount, MultiAmountType.REMOVE_COUNTERS, game);
            for (int i = 0; i < toChoose.size(); ++i) {
                int amountToRemove = counterList.get(i);
                if (amountToRemove <= 0) continue;
                permanent.removeCounters((String)toChoose.get(i), amountToRemove, source, game);
            }
            this.paid = true;
        } else if (permanent.getCounters(game).getCount(this.name) >= this.amount) {
            permanent.removeCounters(this.name, this.amount, source, game);
            this.paid = true;
        }
        return this.paid;
    }

    @Override
    public RemoveCountersSourceCost copy() {
        return new RemoveCountersSourceCost(this);
    }
}

