/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.common;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

public class UntapTargetCost
extends CostImpl {
    private final TargetPermanent target;

    public UntapTargetCost(TargetPermanent target) {
        this.target = target;
        this.text = UntapTargetCost.makeText(target);
        this.target.withNotTarget(true);
    }

    protected UntapTargetCost(UntapTargetCost cost) {
        super(cost);
        this.target = cost.target.copy();
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        if (!this.target.choose(Outcome.Untap, controllerId, source.getSourceId(), source, game)) {
            return this.paid;
        }
        ArrayList<UUID> untapped = new ArrayList<UUID>();
        for (UUID targetId : this.target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) {
                return false;
            }
            int stunCount = permanent.getCounters(game).getCount(CounterType.STUN);
            if (!permanent.untap(game) && (stunCount <= 0 || permanent.getCounters(game).getCount(CounterType.STUN) >= stunCount)) continue;
            untapped.add(targetId);
        }
        game.getState().setValue("UntapTargetCost" + ability.getSourceId().toString(), untapped);
        this.paid |= untapped.size() >= this.target.getMinNumberOfTargets();
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.target.canChooseOrAlreadyChosen(controllerId, source, game);
    }

    @Override
    public UntapTargetCost copy() {
        return new UntapTargetCost(this);
    }

    private static String makeText(TargetPermanent target) {
        StringBuilder sb = new StringBuilder("untap ");
        if (target.getMaxNumberOfTargets() > 1) {
            sb.append(CardUtil.numberToText(target.getMaxNumberOfTargets()));
            sb.append(' ');
            sb.append(target.getTargetName().replace(" you control", "s you control"));
        } else {
            sb.append(CardUtil.addArticle(target.getTargetName()));
        }
        return sb.toString();
    }
}

