/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostImpl;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.players.ManaPool;

public class ColorlessHybridManaCost
extends ManaCostImpl {
    private final ColoredManaSymbol manaColor;

    public ColorlessHybridManaCost(ColoredManaSymbol manaColor) {
        this.manaColor = manaColor;
        this.cost = new Mana(manaColor);
        this.cost.add(Mana.ColorlessMana(1));
        this.addColoredOption(manaColor);
        this.options.add(Mana.ColorlessMana(1));
    }

    public ColorlessHybridManaCost(ColorlessHybridManaCost manaCost) {
        super(manaCost);
        this.manaColor = manaCost.manaColor;
    }

    @Override
    public int manaValue() {
        return 1;
    }

    @Override
    public boolean isPaid() {
        return this.paid || this.isColoredPaid(this.manaColor) || this.isColorlessPaid(1);
    }

    @Override
    public void assignPayment(Game game, Ability ability, ManaPool pool, Cost costToPay) {
        if (!this.assignColorless(ability, game, pool, 1, costToPay)) {
            this.assignColored(ability, game, pool, this.manaColor, costToPay);
        }
    }

    @Override
    public String getText() {
        return "{C/" + this.manaColor.toString() + '}';
    }

    @Override
    public ColorlessHybridManaCost getUnpaid() {
        return this;
    }

    @Override
    public boolean testPay(Mana testMana) {
        switch (this.manaColor) {
            case B: {
                if (testMana.getBlack() > 0) {
                    return true;
                }
            }
            case U: {
                if (testMana.getBlue() > 0) {
                    return true;
                }
            }
            case R: {
                if (testMana.getRed() > 0) {
                    return true;
                }
            }
            case W: {
                if (testMana.getWhite() > 0) {
                    return true;
                }
            }
            case G: {
                if (testMana.getGreen() <= 0) break;
                return true;
            }
        }
        return testMana.getColorless() > 0;
    }

    @Override
    public ColorlessHybridManaCost copy() {
        return new ColorlessHybridManaCost(this);
    }

    @Override
    public boolean containsColor(ColoredManaSymbol coloredManaSymbol) {
        return this.manaColor == coloredManaSymbol;
    }

    public ColoredManaSymbol getManaColor() {
        return this.manaColor;
    }

    @Override
    public List<Mana> getManaOptions() {
        ArrayList<Mana> manaList = new ArrayList<Mana>();
        manaList.add(new Mana(this.manaColor));
        manaList.add(Mana.ColorlessMana(1));
        return manaList;
    }
}

