/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostImpl;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.players.ManaPool;

public class GenericManaCost
extends ManaCostImpl {
    protected int mana;

    public GenericManaCost(int mana) {
        this.mana = mana;
        this.cost = Mana.GenericMana(mana);
        this.options.addMana(Mana.GenericMana(mana));
    }

    protected GenericManaCost(GenericManaCost manaCost) {
        super(manaCost);
        this.mana = manaCost.mana;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    @Override
    public int manaValue() {
        return this.mana;
    }

    @Override
    public boolean isPaid() {
        if (this.paid) {
            return true;
        }
        return this.isColorlessPaid(this.mana);
    }

    @Override
    public void assignPayment(Game game, Ability ability, ManaPool pool, Cost costsToPay) {
        this.assignGeneric(ability, game, pool, this.mana, null, costsToPay);
    }

    @Override
    public String getText() {
        return '{' + Integer.toString(this.mana) + '}';
    }

    @Override
    public GenericManaCost getUnpaid() {
        GenericManaCost unpaid = new GenericManaCost(this.mana - this.payment.count());
        if (this.sourceFilter != null) {
            unpaid.setSourceFilter(this.sourceFilter);
        }
        return unpaid;
    }

    @Override
    public boolean testPay(Mana testMana) {
        return testMana.count() > 0;
    }

    @Override
    public GenericManaCost copy() {
        return new GenericManaCost(this);
    }

    @Override
    public boolean containsColor(ColoredManaSymbol coloredManaSymbol) {
        return false;
    }
}

