/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.costs.mana;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import mage.ManaSymbol;
import mage.abilities.costs.mana.ColoredManaCost;
import mage.abilities.costs.mana.HybridManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.constants.ColoredManaSymbol;

public class ManaSymbols
extends ArrayList<ManaSymbol> {
    private static final Map<ColoredManaSymbol, ManaSymbol> coloredManaMap = new EnumMap<ColoredManaSymbol, ManaSymbol>(ColoredManaSymbol.class){
        {
            this.put(ColoredManaSymbol.W, ManaSymbol.W);
            this.put(ColoredManaSymbol.U, ManaSymbol.U);
            this.put(ColoredManaSymbol.B, ManaSymbol.B);
            this.put(ColoredManaSymbol.R, ManaSymbol.R);
            this.put(ColoredManaSymbol.G, ManaSymbol.G);
        }
    };
    private static final Map<ManaSymbol, HybridManaCost> hybridManaMap = new EnumMap<ManaSymbol, HybridManaCost>(ManaSymbol.class){
        {
            this.put(ManaSymbol.HYBRID_BG, new HybridManaCost(ColoredManaSymbol.B, ColoredManaSymbol.G));
            this.put(ManaSymbol.HYBRID_BR, new HybridManaCost(ColoredManaSymbol.B, ColoredManaSymbol.R));
            this.put(ManaSymbol.HYBRID_GU, new HybridManaCost(ColoredManaSymbol.G, ColoredManaSymbol.U));
            this.put(ManaSymbol.HYBRID_GW, new HybridManaCost(ColoredManaSymbol.G, ColoredManaSymbol.W));
            this.put(ManaSymbol.HYBRID_RG, new HybridManaCost(ColoredManaSymbol.R, ColoredManaSymbol.G));
            this.put(ManaSymbol.HYBRID_RW, new HybridManaCost(ColoredManaSymbol.R, ColoredManaSymbol.W));
            this.put(ManaSymbol.HYBRID_UB, new HybridManaCost(ColoredManaSymbol.U, ColoredManaSymbol.B));
            this.put(ManaSymbol.HYBRID_UR, new HybridManaCost(ColoredManaSymbol.U, ColoredManaSymbol.R));
            this.put(ManaSymbol.HYBRID_WB, new HybridManaCost(ColoredManaSymbol.W, ColoredManaSymbol.B));
            this.put(ManaSymbol.HYBRID_WU, new HybridManaCost(ColoredManaSymbol.W, ColoredManaSymbol.U));
        }
    };

    public static ManaSymbols buildFromManaCost(ManaCost manaCost) {
        ManaSymbols manaSymbols = new ManaSymbols();
        if (manaCost instanceof ManaCostsImpl) {
            ManaCostsImpl manaCosts = (ManaCostsImpl)manaCost;
            block0: for (int i = 0; i < manaCosts.size(); ++i) {
                ManaCost mc = (ManaCost)manaCosts.get(i);
                if (mc instanceof ColoredManaCost) {
                    for (Map.Entry<Enum, Object> entry : coloredManaMap.entrySet()) {
                        if (!mc.containsColor((ColoredManaSymbol)entry.getKey())) continue;
                        manaSymbols.add(entry.getValue());
                        continue block0;
                    }
                    continue;
                }
                if (!(mc instanceof HybridManaCost)) continue;
                for (Map.Entry<Enum, Object> entry : hybridManaMap.entrySet()) {
                    if (!ManaSymbols.compareHybridCosts((HybridManaCost)mc, (HybridManaCost)entry.getValue())) continue;
                    manaSymbols.add(entry.getKey());
                    continue block0;
                }
            }
        }
        return manaSymbols;
    }

    private static boolean compareHybridCosts(HybridManaCost h1, HybridManaCost h2) {
        return h1.getMana1() == h2.getMana1() && h1.getMana2() == h2.getMana2() || h1.getMana1() == h2.getMana2() && h1.getMana2() == h2.getMana1();
    }
}

