/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.AsThoughEffect;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.Duration;
import mage.game.Game;

public class ConditionalAsThoughEffect
extends AsThoughEffectImpl {
    protected AsThoughEffect effect;
    protected AsThoughEffect otherwiseEffect;
    protected Condition condition;
    protected boolean conditionState;

    public ConditionalAsThoughEffect(AsThoughEffect effect, Condition condition) {
        this(effect, condition, null);
    }

    public ConditionalAsThoughEffect(AsThoughEffect effect, Condition condition, AsThoughEffect otherwiseEffect) {
        super(effect.getAsThoughEffectType(), effect.getDuration(), effect.getOutcome());
        this.effect = effect;
        this.condition = condition;
        this.otherwiseEffect = otherwiseEffect;
    }

    protected ConditionalAsThoughEffect(ConditionalAsThoughEffect effect) {
        super(effect);
        this.effect = effect.effect.copy();
        if (effect.otherwiseEffect != null) {
            this.otherwiseEffect = effect.otherwiseEffect.copy();
        }
        this.condition = effect.condition;
        this.conditionState = effect.conditionState;
    }

    @Override
    public boolean isDiscarded() {
        return this.effect.isDiscarded() || this.otherwiseEffect != null && this.otherwiseEffect.isDiscarded();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        this.conditionState = this.condition.apply(game, source);
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.apply(game, source);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.apply(game, source);
        }
        if (!this.conditionState && this.effect.getDuration() == Duration.OneUse) {
            this.used = true;
        }
        if (!this.conditionState && this.effect.getDuration() == Duration.Custom) {
            this.discard();
        }
        return false;
    }

    @Override
    public boolean applies(UUID sourceId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        this.conditionState = this.condition.apply(game, source);
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.applies(sourceId, affectedAbility, source, game, playerId);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.applies(sourceId, affectedAbility, source, game, playerId);
        }
        return false;
    }

    @Override
    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        this.conditionState = this.condition.apply(game, source);
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.applies(sourceId, source, affectedControllerId, game);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.applies(sourceId, source, affectedControllerId, game);
        }
        return false;
    }

    @Override
    public ConditionalAsThoughEffect copy() {
        return new ConditionalAsThoughEffect(this);
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

