/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.condition.FixedCondition;
import mage.abilities.condition.LockedInCondition;
import mage.abilities.effects.ContinuousRuleModifyingEffect;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.game.Game;
import mage.game.events.GameEvent;

public class ConditionalContinuousRuleModifyingEffect
extends ContinuousRuleModifyingEffectImpl {
    protected ContinuousRuleModifyingEffect effect;
    protected ContinuousRuleModifyingEffect otherwiseEffect;
    protected Condition condition;
    protected Condition baseCondition;
    protected boolean initDone = false;

    public ConditionalContinuousRuleModifyingEffect(ContinuousRuleModifyingEffect effect, Condition condition) {
        this(effect, condition, null);
    }

    public ConditionalContinuousRuleModifyingEffect(ContinuousRuleModifyingEffect effect, Condition condition, ContinuousRuleModifyingEffect otherwiseEffect) {
        super(effect.getDuration(), effect.getOutcome());
        this.effect = effect;
        this.baseCondition = condition;
        this.otherwiseEffect = otherwiseEffect;
    }

    protected ConditionalContinuousRuleModifyingEffect(ConditionalContinuousRuleModifyingEffect effect) {
        super(effect);
        this.effect = (ContinuousRuleModifyingEffect)effect.effect.copy();
        if (effect.otherwiseEffect != null) {
            this.otherwiseEffect = (ContinuousRuleModifyingEffect)effect.otherwiseEffect.copy();
        }
        this.condition = effect.condition;
        this.baseCondition = effect.baseCondition;
        this.initDone = effect.initDone;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.condition = this.baseCondition instanceof LockedInCondition ? new FixedCondition(((LockedInCondition)this.baseCondition).getBaseCondition().apply(game, source)) : this.baseCondition;
        this.effect.setTargetPointer(this.getTargetPointer().copy());
        this.effect.init(source, game);
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            this.otherwiseEffect.init(source, game);
        }
        this.initDone = true;
    }

    @Override
    public boolean isDiscarded() {
        return this.effect.isDiscarded() || this.otherwiseEffect != null && this.otherwiseEffect.isDiscarded();
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        if (this.effect.checksEventType(event, game)) {
            return true;
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.checksEventType(event, game);
        }
        return false;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.initDone) {
            this.init(source, game);
        }
        if (this.condition.apply(game, source)) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.applies(event, source, game);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.applies(event, source, game);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText == null || this.staticText.isEmpty() && this.effect != null) {
            return this.effect.getText(mode);
        }
        return this.staticText;
    }

    @Override
    public ConditionalContinuousRuleModifyingEffect copy() {
        return new ConditionalContinuousRuleModifyingEffect(this);
    }

    @Override
    public boolean sendMessageToGameLog() {
        return this.effect.sendMessageToGameLog();
    }

    @Override
    public boolean sendMessageToUser() {
        return this.effect.sendMessageToUser();
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        return this.effect.getInfoMessage(source, event, game);
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

