/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

public class ConditionalOneShotEffect
extends OneShotEffect {
    private final Effects effects = new Effects(new Effect[0]);
    private final Effects otherwiseEffects = new Effects(new Effect[0]);
    private final Condition condition;
    private boolean withConditionTextAtEnd = false;

    public ConditionalOneShotEffect(OneShotEffect effect, Condition condition) {
        this(effect, null, condition, null);
    }

    public ConditionalOneShotEffect(OneShotEffect effect, Condition condition, String text) {
        this(effect, null, condition, text);
    }

    private static Outcome generateOutcome(OneShotEffect effect, OneShotEffect otherwiseEffect) {
        if (effect != null) {
            return effect.getOutcome();
        }
        if (otherwiseEffect != null) {
            return Outcome.inverse(otherwiseEffect.getOutcome());
        }
        throw new IllegalArgumentException("Wrong code usage: ConditionalOneShot should start with an effect to generate Outcome.");
    }

    public ConditionalOneShotEffect(OneShotEffect effect, OneShotEffect otherwiseEffect, Condition condition, String text) {
        super(ConditionalOneShotEffect.generateOutcome(effect, otherwiseEffect));
        if (effect != null) {
            this.effects.add(effect);
        }
        if (otherwiseEffect != null) {
            this.otherwiseEffects.add(otherwiseEffect);
        }
        this.condition = condition;
        this.staticText = text;
    }

    protected ConditionalOneShotEffect(ConditionalOneShotEffect effect) {
        super(effect);
        this.effects.addAll(effect.effects.copy());
        this.otherwiseEffects.addAll(effect.otherwiseEffects.copy());
        this.condition = effect.condition;
        this.withConditionTextAtEnd = effect.withConditionTextAtEnd;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Effects toApply;
        Effects effects = toApply = this.condition.apply(game, source) ? this.effects : this.otherwiseEffects;
        if (toApply.isEmpty()) {
            return true;
        }
        toApply.setTargetPointer(this.getTargetPointer().copy());
        toApply.stream().forEach(effect -> effect.apply(game, source));
        return true;
    }

    public ConditionalOneShotEffect addEffect(OneShotEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public ConditionalOneShotEffect addOtherwiseEffect(OneShotEffect effect) {
        this.otherwiseEffects.add(effect);
        return this;
    }

    public ConditionalOneShotEffect withConditionTextAtEnd(boolean withConditionTextAtEnd) {
        this.withConditionTextAtEnd = withConditionTextAtEnd;
        return this;
    }

    @Override
    public void setValue(String key, Object value) {
        super.setValue(key, value);
        this.effects.setValue(key, value);
        this.otherwiseEffects.setValue(key, value);
    }

    @Override
    public ConditionalOneShotEffect copy() {
        return new ConditionalOneShotEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String conditionText = this.condition.toString();
        if (conditionText.startsWith("if ") || conditionText.startsWith("If ")) {
            conditionText = conditionText.substring(3);
        }
        if (this.otherwiseEffects.isEmpty()) {
            if (this.withConditionTextAtEnd) {
                String effectText = this.effects.getText(mode);
                return CardUtil.getTextWithFirstCharLowerCase(effectText.substring(0, effectText.length() - 1)) + " if " + conditionText;
            }
            return "if " + conditionText + ", " + CardUtil.getTextWithFirstCharLowerCase(this.effects.getText(mode));
        }
        return this.effects.getText(mode) + ". If " + conditionText + ", " + CardUtil.getTextWithFirstCharLowerCase(this.otherwiseEffects.getText(mode));
    }

    @Override
    public ConditionalOneShotEffect setTargetPointer(TargetPointer targetPointer) {
        this.effects.setTargetPointer(targetPointer);
        this.otherwiseEffects.setTargetPointer(targetPointer);
        super.setTargetPointer(targetPointer);
        return this;
    }

    @Override
    public ConditionalOneShotEffect withTargetDescription(String target) {
        this.effects.forEach(effect -> effect.withTargetDescription(target));
        this.otherwiseEffects.forEach(effect -> effect.withTargetDescription(target));
        return this;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

