/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.decorator;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.FixedCondition;
import mage.abilities.condition.LockedInCondition;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class ConditionalRequirementEffect
extends RequirementEffect {
    protected RequirementEffect effect;
    protected RequirementEffect otherwiseEffect;
    protected Condition condition;
    protected boolean conditionState;
    protected Condition baseCondition;
    protected boolean initDone = false;

    public ConditionalRequirementEffect(RequirementEffect effect, Condition condition) {
        this(effect, condition, null);
    }

    public ConditionalRequirementEffect(RequirementEffect effect, Condition condition, String text) {
        this(effect.getDuration(), effect, condition, null);
        if (text != null) {
            this.setText(text);
        }
    }

    public ConditionalRequirementEffect(Duration duration, RequirementEffect effect, Condition condition, RequirementEffect otherwiseEffect) {
        super(duration);
        this.effectType = EffectType.REQUIREMENT;
        this.effect = effect;
        this.baseCondition = condition;
        this.otherwiseEffect = otherwiseEffect;
    }

    protected ConditionalRequirementEffect(ConditionalRequirementEffect effect) {
        super(effect);
        this.effect = (RequirementEffect)effect.effect.copy();
        if (effect.otherwiseEffect != null) {
            this.otherwiseEffect = (RequirementEffect)effect.otherwiseEffect.copy();
        }
        this.condition = effect.condition;
        this.conditionState = effect.conditionState;
        this.baseCondition = effect.baseCondition;
        this.initDone = effect.initDone;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        this.condition = this.baseCondition instanceof LockedInCondition ? new FixedCondition(((LockedInCondition)this.baseCondition).getBaseCondition().apply(game, source)) : this.baseCondition;
        this.effect.setTargetPointer(this.getTargetPointer().copy());
        this.effect.init(source, game);
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            this.otherwiseEffect.init(source, game);
        }
        this.initDone = true;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (!this.initDone) {
            this.init(source, game);
        }
        this.conditionState = this.condition.apply(game, source);
        if (this.conditionState) {
            this.effect.setTargetPointer(this.getTargetPointer().copy());
            return this.effect.applies(permanent, source, game);
        }
        if (this.otherwiseEffect != null) {
            this.otherwiseEffect.setTargetPointer(this.getTargetPointer().copy());
            return this.otherwiseEffect.applies(permanent, source, game);
        }
        if (!this.conditionState && this.effect.getDuration() == Duration.OneUse) {
            this.used = true;
        }
        if (!this.conditionState && this.effect.getDuration() == Duration.Custom) {
            this.discard();
        }
        return false;
    }

    @Override
    public boolean mustAttack(Game game) {
        if (this.conditionState) {
            return this.effect.mustAttack(game);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.mustAttack(game);
        }
        return false;
    }

    @Override
    public boolean mustBlock(Game game) {
        if (this.conditionState) {
            return this.effect.mustBlock(game);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.mustBlock(game);
        }
        return false;
    }

    @Override
    public boolean mustBlockAny(Game game) {
        if (this.conditionState) {
            return this.effect.mustBlockAny(game);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.mustBlockAny(game);
        }
        return false;
    }

    @Override
    public boolean mustBlockAllAttackers(Game game) {
        if (this.conditionState) {
            return this.effect.mustBlockAllAttackers(game);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.mustBlockAllAttackers(game);
        }
        return false;
    }

    @Override
    public UUID mustAttackDefender(Ability source, Game game) {
        if (this.conditionState) {
            return this.effect.mustAttackDefender(source, game);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.mustAttackDefender(source, game);
        }
        return null;
    }

    @Override
    public UUID mustBlockAttacker(Ability source, Game game) {
        if (this.conditionState) {
            return this.effect.mustBlockAttacker(source, game);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.mustBlockAttacker(source, game);
        }
        return null;
    }

    @Override
    public UUID mustBlockAttackerIfElseUnblocked(Ability source, Game game) {
        if (this.conditionState) {
            return this.effect.mustBlockAttackerIfElseUnblocked(source, game);
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.mustBlockAttackerIfElseUnblocked(source, game);
        }
        return null;
    }

    @Override
    public int getMinNumberOfBlockers() {
        if (this.conditionState) {
            return this.effect.getMinNumberOfBlockers();
        }
        if (this.otherwiseEffect != null) {
            return this.otherwiseEffect.getMinNumberOfBlockers();
        }
        return super.getMinNumberOfBlockers();
    }

    @Override
    public ConditionalRequirementEffect copy() {
        return new ConditionalRequirementEffect(this);
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }
}

