/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

public class CardsInControllerGraveyardCount
implements DynamicValue {
    private final FilterCard filter;
    private final Integer multiplier;

    public CardsInControllerGraveyardCount() {
        this(StaticFilters.FILTER_CARD, 1);
    }

    public CardsInControllerGraveyardCount(FilterCard filter) {
        this(filter, 1);
    }

    public CardsInControllerGraveyardCount(FilterCard filter, Integer multiplier) {
        this.filter = filter;
        this.multiplier = multiplier;
    }

    protected CardsInControllerGraveyardCount(CardsInControllerGraveyardCount dynamicValue) {
        this.filter = dynamicValue.filter;
        this.multiplier = dynamicValue.multiplier;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        UUID playerId = sourceAbility.getControllerId();
        Player player = game.getPlayer(playerId);
        if (player == null) {
            return 0;
        }
        int value = player.getGraveyard().count(this.filter, playerId, sourceAbility, game);
        if (this.multiplier != null) {
            value *= this.multiplier.intValue();
        }
        return value;
    }

    @Override
    public CardsInControllerGraveyardCount copy() {
        return new CardsInControllerGraveyardCount(this);
    }

    public String toString() {
        return this.multiplier == null ? "X" : this.multiplier.toString();
    }

    @Override
    public String getMessage() {
        return (this.multiplier == null ? "the number of " : "") + this.filter.getMessage() + " in your graveyard";
    }

    @Override
    public int getSign() {
        return this.multiplier == null ? 1 : this.multiplier;
    }
}

