/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.AbilityType;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.ManaSpentToCastWatcher;

public enum EachTwoManaSpentToCastValue implements DynamicValue
{
    WHITE(ColoredManaSymbol.W),
    BLUE(ColoredManaSymbol.U),
    BLACK(ColoredManaSymbol.B),
    RED(ColoredManaSymbol.R),
    GREEN(ColoredManaSymbol.G);

    private final ColoredManaSymbol coloredManaSymbol;

    private EachTwoManaSpentToCastValue(ColoredManaSymbol manaSymbol) {
        this.coloredManaSymbol = manaSymbol;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        if (sourceAbility.getAbilityType() == AbilityType.SPELL) {
            return sourceAbility.getManaCostsToPay().getUsedManaToPay().getColor(this.coloredManaSymbol) / 2;
        }
        Mana payment = game.getState().getWatcher(ManaSpentToCastWatcher.class).getManaPayment(CardUtil.getSourceStackMomentReference(game, sourceAbility));
        if (payment == null) {
            return 0;
        }
        return payment.getColor(this.coloredManaSymbol) / 2;
    }

    @Override
    public EachTwoManaSpentToCastValue copy() {
        return this;
    }

    @Override
    public String getMessage() {
        return "for each {" + (Object)((Object)this.coloredManaSymbol) + "}{" + (Object)((Object)this.coloredManaSymbol) + "} spent to cast it";
    }
}

