/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.dynamicvalue.common;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.game.permanent.Permanent;

public enum SourcePermanentPowerValue implements DynamicValue
{
    ALLOW_NEGATIVE(true),
    NOT_NEGATIVE(false);

    private final boolean allowNegativeValues;

    private SourcePermanentPowerValue(boolean allowNegativeValues) {
        this.allowNegativeValues = allowNegativeValues;
    }

    @Override
    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Permanent sourcePermanent = sourceAbility.getSourcePermanentOrLKI(game);
        if (sourcePermanent == null) {
            return 0;
        }
        int value = sourcePermanent.getPower().getValue();
        if (this.allowNegativeValues || value > 0) {
            return value;
        }
        return 0;
    }

    @Override
    public SourcePermanentPowerValue copy() {
        return this;
    }

    public String toString() {
        return "X";
    }

    @Override
    public String getMessage() {
        return "{this}'s power";
    }
}

