/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.MenaceAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.AbilityCounter;
import mage.counters.BoostCounter;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class ApplyStatusEffect
extends ContinuousEffectImpl {
    ApplyStatusEffect() {
        super(Duration.EndOfGame, Outcome.BoostCreature);
    }

    private ApplyStatusEffect(ApplyStatusEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (layer == Layer.AbilityAddingRemovingEffects_6) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
                for (AbilityCounter abilityCounter : permanent.getCounters(game).getAbilityCounters()) {
                    permanent.addAbility(abilityCounter.getAbility(), source == null ? permanent.getId() : source.getSourceId(), game);
                }
                if (!permanent.isSuspected()) continue;
                permanent.addAbility(new MenaceAbility(false), source == null ? permanent.getId() : source.getSourceId(), game);
            }
        }
        if (layer == Layer.PTChangingEffects_7 && sublayer == SubLayer.Counters_7d) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(CardType.CREATURE, game)) {
                for (BoostCounter boostCounter : permanent.getCounters(game).getBoostCounters()) {
                    permanent.addPower(boostCounter.getPower() * boostCounter.getCount());
                    permanent.addToughness(boostCounter.getToughness() * boostCounter.getCount());
                }
            }
        }
        return true;
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6;
    }

    @Override
    public ApplyStatusEffect copy() {
        return new ApplyStatusEffect(this);
    }
}

