/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.MageSingleton;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.target.targetpointer.FirstTargetPointer;
import mage.target.targetpointer.TargetPointer;

public abstract class EffectImpl
implements Effect {
    protected UUID id;
    protected Outcome outcome;
    protected EffectType effectType;
    private TargetPointer targetPointer = new FirstTargetPointer();
    protected String staticText = "";
    protected Map<String, Object> values;
    protected String concatPrefix = "";

    public EffectImpl(Outcome outcome) {
        this.id = UUID.randomUUID();
        this.outcome = outcome;
        this.initNewTargetPointer();
    }

    protected EffectImpl(EffectImpl effect) {
        this.id = effect.id;
        this.outcome = effect.outcome;
        this.staticText = effect.staticText;
        this.effectType = effect.effectType;
        this.targetPointer = effect.targetPointer.copy();
        this.concatPrefix = effect.concatPrefix;
        if (effect.values != null) {
            this.values = new HashMap<String, Object>();
            Map<String, Object> map = effect.values;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.values.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public abstract void initNewTargetPointer();

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getText(Mode mode) {
        return this.staticText;
    }

    @Override
    public Effect setText(String staticText) {
        this.staticText = staticText;
        return this;
    }

    @Override
    public Outcome getOutcome() {
        return this.outcome;
    }

    @Override
    public void setOutcome(Outcome outcome) {
        this.outcome = outcome;
    }

    @Override
    public EffectType getEffectType() {
        return this.effectType;
    }

    @Override
    public Effect setTargetPointer(TargetPointer targetPointer) {
        if (targetPointer == null) {
            throw new IllegalArgumentException("Wrong code usage: target pointer can't be set to null: " + this);
        }
        targetPointer.setTargetDescription(this.targetPointer.getTargetDescription());
        this.targetPointer = targetPointer;
        this.initNewTargetPointer();
        return this;
    }

    @Override
    public TargetPointer getTargetPointer() {
        return this.targetPointer;
    }

    @Override
    public Effect withTargetDescription(String target) {
        this.targetPointer.setTargetDescription(target);
        return this;
    }

    @Override
    public void newId() {
        if (!(this instanceof MageSingleton)) {
            this.id = UUID.randomUUID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String key, Object value) {
        EffectImpl effectImpl = this;
        synchronized (effectImpl) {
            if (this.values == null) {
                this.values = new HashMap<String, Object>();
            }
        }
        this.values.put(key, value);
    }

    @Override
    public Object getValue(String key) {
        if (this.values == null) {
            return null;
        }
        return this.values.get(key);
    }

    @Override
    public Effect concatBy(String concatPrefix) {
        this.concatPrefix = concatPrefix;
        return this;
    }

    @Override
    public String getConcatPrefix() {
        return this.concatPrefix;
    }
}

