/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.constants.Outcome;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

public class Effects
extends ArrayList<Effect> {
    public Effects(Effect ... effects) {
        this.addAll(Arrays.asList(effects));
    }

    protected Effects(Effects effects) {
        for (Effect effect : effects) {
            this.add(effect.copy());
        }
    }

    public Effects copy() {
        return new Effects(this);
    }

    public String getTextStartingUpperCase(Mode mode) {
        StringBuilder text = Optional.of(this.getText(mode)).map(s -> s.length() > 3 ? CardUtil.getTextWithFirstCharUpperCase(s) : s).map(StringBuilder::new).get();
        if (mode.getCost() != null) {
            text.insert(0, " &mdash; ");
            text.insert(0, mode.getCost().getText());
        }
        if (mode.getFlavorWord() != null) {
            text.insert(0, CardUtil.italicizeWithEmDash(mode.getFlavorWord()));
        }
        return text.toString();
    }

    public String getText(Mode mode) {
        StringBuilder sbText = new StringBuilder();
        String lastRule = null;
        int effectNum = 0;
        for (Effect effect : this) {
            String endString = "";
            String nextRule = effect.getText(mode);
            if (nextRule == null || nextRule.isEmpty()) continue;
            String concatPrefix = effect.getConcatPrefix();
            if (++effectNum > 1 && !concatPrefix.isEmpty() && !concatPrefix.equals(".")) {
                nextRule = concatPrefix.contains("<br>") ? concatPrefix + CardUtil.getTextWithFirstCharUpperCase(nextRule) : concatPrefix + " " + nextRule;
            }
            if (nextRule.startsWith("and ") || nextRule.startsWith("with ") || nextRule.startsWith("then ") || nextRule.startsWith("or ")) {
                endString = " ";
            } else if (nextRule.startsWith(",") || nextRule.startsWith(" ")) {
                endString = "";
            } else if (lastRule != null && lastRule.length() > 3) {
                if (lastRule.endsWith(".\"") || lastRule.endsWith(".]") || lastRule.endsWith(".)") || lastRule.endsWith(".)</i>") || lastRule.endsWith(".")) {
                    endString = " ";
                } else if (!lastRule.endsWith(".") && !lastRule.endsWith("<br>")) {
                    endString = ". ";
                }
                if (nextRule.length() > 3) {
                    nextRule = Character.toUpperCase(nextRule.charAt(0)) + nextRule.substring(1);
                }
            }
            String currentRule = endString + nextRule;
            if (sbText.length() > 0 && currentRule.length() > 0) {
                boolean currentTextStartsWithDot;
                boolean prevTextEndsWithDot = sbText.charAt(sbText.length() - 1) == '.';
                boolean bl = currentTextStartsWithDot = currentRule.startsWith(",") || currentRule.startsWith(".");
                if (prevTextEndsWithDot && currentTextStartsWithDot) {
                    sbText.delete(sbText.length() - 1, sbText.length());
                }
            }
            sbText.append(currentRule);
            lastRule = nextRule;
        }
        if (!(lastRule == null || lastRule.length() <= 3 || lastRule.endsWith(".") || lastRule.endsWith("!") || lastRule.endsWith("\"") || lastRule.endsWith(".]") || lastRule.startsWith("<b>LEVEL ") || lastRule.endsWith(".)") || lastRule.endsWith("<br>") || lastRule.endsWith("</i>"))) {
            sbText.append('.');
        }
        return sbText.toString();
    }

    public boolean hasOutcome(Ability source, Outcome outcome) {
        Outcome realOutcome;
        Outcome outcome2 = realOutcome = source == null ? null : source.getCustomOutcome();
        if (realOutcome != null) {
            return realOutcome == outcome;
        }
        for (Effect effect : this) {
            if (effect.getOutcome() != outcome) continue;
            return true;
        }
        return false;
    }

    public Outcome getOutcome(Ability source) {
        return this.getOutcome(source, Outcome.Detriment);
    }

    public Outcome getOutcome(Ability source, Outcome defaultOutcome) {
        Outcome realOutcome;
        Outcome outcome = realOutcome = source == null ? null : source.getCustomOutcome();
        if (realOutcome != null) {
            return realOutcome;
        }
        if (!this.isEmpty()) {
            return ((Effect)this.get(0)).getOutcome();
        }
        return defaultOutcome;
    }

    public int getOutcomeScore(Ability source) {
        int total = 0;
        for (Effect effect : this) {
            Outcome realOutcome;
            Outcome outcome = realOutcome = source == null ? null : source.getCustomOutcome();
            if (realOutcome == null) {
                realOutcome = effect.getOutcome();
            }
            if (realOutcome.isGood()) {
                ++total;
                continue;
            }
            --total;
        }
        return total;
    }

    public void newId() {
        for (Effect effect : this) {
            effect.newId();
        }
    }

    public void setTargetPointer(TargetPointer targetPointer) {
        if (targetPointer == null) {
            return;
        }
        for (Effect effect : this) {
            effect.setTargetPointer(targetPointer.copy());
        }
    }

    public void setValue(String key, Object value) {
        for (Effect effect : this) {
            effect.setValue(key, value);
        }
    }
}

