/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.TargetPermanent;

@Deprecated
public class PlaneswalkerRedirectionEffect
extends RedirectionEffect {
    public PlaneswalkerRedirectionEffect() {
        super(Duration.EndOfGame);
    }

    protected PlaneswalkerRedirectionEffect(PlaneswalkerRedirectionEffect effect) {
        super(effect);
    }

    @Override
    public PlaneswalkerRedirectionEffect copy() {
        return new PlaneswalkerRedirectionEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        DamageEvent damageEvent = (DamageEvent)event;
        UUID playerId = this.getSourceControllerId(event.getSourceId(), game);
        if (!damageEvent.isCombatDamage() && game.getOpponents(event.getTargetId()).contains(playerId)) {
            int numPlaneswalkers;
            Player target = game.getPlayer(event.getTargetId());
            Player player = game.getPlayer(playerId);
            if (target != null && player != null && (numPlaneswalkers = game.getBattlefield().countAll(StaticFilters.FILTER_PERMANENT_PLANESWALKER, target.getId(), game)) > 0 && player.chooseUse(this.outcome, "Redirect damage to planeswalker?", source, game)) {
                Permanent redirectTo;
                this.redirectTarget = new TargetPermanent(StaticFilters.FILTER_PERMANENT_PLANESWALKER);
                if (numPlaneswalkers == 1) {
                    List<Permanent> planeswalker = game.getBattlefield().getAllActivePermanents(StaticFilters.FILTER_PERMANENT_PLANESWALKER, target.getId(), game);
                    if (!planeswalker.isEmpty()) {
                        this.redirectTarget.add(planeswalker.get(0).getId(), game);
                    }
                } else {
                    player.choose(Outcome.Damage, this.redirectTarget, source, game);
                }
                if (!game.isSimulation() && (redirectTo = game.getPermanent(this.redirectTarget.getFirstTarget())) != null) {
                    game.informPlayers(player.getLogName() + " redirects " + event.getAmount() + " damage to " + redirectTo.getLogName());
                }
                return true;
            }
        }
        return false;
    }

    private UUID getSourceControllerId(UUID sourceId, Game game) {
        StackObject source = game.getStack().getStackObject(sourceId);
        if (source != null) {
            return source.getControllerId();
        }
        Permanent permanent = game.getPermanent(sourceId);
        if (permanent != null) {
            return permanent.getControllerId();
        }
        return game.getContinuousEffects().getControllerOfSourceId(sourceId);
    }
}

