/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

public abstract class RedirectionEffect
extends ReplacementEffectImpl {
    protected Target redirectTarget;
    protected int amountToRedirect;
    protected UsageType usageType;
    protected int applyEffectsCounter;

    public RedirectionEffect(Duration duration) {
        this(duration, Integer.MAX_VALUE, UsageType.ACCORDING_DURATION);
        this.applyEffectsCounter = -1;
    }

    public RedirectionEffect(Duration duration, int amountToRedirect, UsageType usageType) {
        super(duration, Outcome.RedirectDamage);
        this.effectType = EffectType.REDIRECTION;
        this.amountToRedirect = amountToRedirect;
        this.usageType = usageType;
    }

    protected RedirectionEffect(RedirectionEffect effect) {
        super(effect);
        this.redirectTarget = effect.redirectTarget;
        this.amountToRedirect = effect.amountToRedirect;
        this.usageType = effect.usageType;
        this.applyEffectsCounter = effect.applyEffectsCounter;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        int damageToRedirect = event.getAmount();
        if (damageToRedirect < 1) {
            return false;
        }
        String sourceLogName = source != null ? game.getObject(source).getLogName() + ": " : "";
        DamageEvent damageEvent = (DamageEvent)event;
        int restDamage = 0;
        if (damageEvent.getAmount() > this.amountToRedirect) {
            restDamage = damageEvent.getAmount() - this.amountToRedirect;
            damageToRedirect = this.amountToRedirect;
        }
        if (damageToRedirect > 0 && this.usageType != UsageType.ACCORDING_DURATION) {
            if (UsageType.ONE_USAGE_ABSOLUTE == this.usageType) {
                this.discard();
            }
            if (this.applyEffectsCounter > 0) {
                if (this.applyEffectsCounter < game.getState().getApplyEffectsCounter()) {
                    this.discard();
                    return false;
                }
            } else {
                this.applyEffectsCounter = game.getState().getApplyEffectsCounter();
            }
        }
        if (this.usageType == UsageType.ACCORDING_DURATION) {
            this.amountToRedirect -= damageEvent.getAmount();
            if (this.amountToRedirect <= 0) {
                this.discard();
            }
        }
        if ((permanent = game.getPermanent(this.redirectTarget.getFirstTarget())) != null) {
            permanent.damage(damageToRedirect, event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
            game.informPlayers(sourceLogName + "Redirected " + damageToRedirect + " damage" + this.getRedirectedFromText(event, game) + " to " + permanent.getLogName());
        } else {
            Player player = game.getPlayer(this.redirectTarget.getFirstTarget());
            if (player != null) {
                player.damage(damageToRedirect, event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
                game.informPlayers(sourceLogName + "Redirected " + damageToRedirect + " damage" + this.getRedirectedFromText(event, game) + " to " + player.getLogName());
            }
        }
        if (restDamage > 0) {
            damageEvent.setAmount(restDamage);
            return false;
        }
        return true;
    }

    private String getRedirectedFromText(GameEvent event, Game game) {
        Player player = game.getPlayer(event.getTargetId());
        if (player != null) {
            return " from " + player.getLogName();
        }
        MageObject mageObject = game.getObject(event.getTargetId());
        if (mageObject != null) {
            return " from " + mageObject.getLogName();
        }
        return "";
    }

    public static enum UsageType {
        ACCORDING_DURATION,
        ONE_USAGE_ABSOLUTE,
        ONE_USAGE_AT_THE_SAME_TIME;

    }
}

