/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AddCounterSourceReplacementEffect
extends ReplacementEffectImpl {
    private final Counter counter;

    public AddCounterSourceReplacementEffect(Counter counter) {
        super(Duration.EndOfStep, Outcome.BoostCreature);
        this.counter = counter;
    }

    private AddCounterSourceReplacementEffect(AddCounterSourceReplacementEffect effect) {
        super(effect);
        this.counter = effect.counter.copy();
    }

    @Override
    public AddCounterSourceReplacementEffect copy() {
        return new AddCounterSourceReplacementEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature == null) {
            return false;
        }
        creature.addCounters(this.counter.copy(), source.getControllerId(), source, game, event.getAppliedEffects());
        this.discard();
        return false;
    }
}

