/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

public class CantBeRegeneratedSourceEffect
extends ContinuousRuleModifyingEffectImpl {
    public CantBeRegeneratedSourceEffect(Duration duration) {
        super(duration, Outcome.Benefit, false, false);
        this.staticText = this.buildStaticText();
    }

    protected CantBeRegeneratedSourceEffect(CantBeRegeneratedSourceEffect effect) {
        super(effect);
    }

    @Override
    public CantBeRegeneratedSourceEffect copy() {
        return new CantBeRegeneratedSourceEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.REGENERATE;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.duration.isOnlyValidIfNoZoneChange() && source.getSourcePermanentIfItStillExists(game) == null) {
            this.discard();
        }
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return Objects.equals(source.getSourceId(), event.getTargetId());
    }

    private String buildStaticText() {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{this} can't be regenerated");
        if (!this.duration.toString().isEmpty()) {
            if (this.duration == Duration.EndOfTurn) {
                sb.append(" this turn");
            } else {
                sb.append(' ').append(this.duration.toString());
            }
        }
        return sb.toString();
    }
}

