/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

public class CantBeRegeneratedTargetEffect
extends ContinuousRuleModifyingEffectImpl {
    public CantBeRegeneratedTargetEffect(Duration duration) {
        super(duration, Outcome.Benefit, false, false);
    }

    protected CantBeRegeneratedTargetEffect(CantBeRegeneratedTargetEffect effect) {
        super(effect);
    }

    @Override
    public CantBeRegeneratedTargetEffect copy() {
        return new CantBeRegeneratedTargetEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.REGENERATE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(event.getTargetId());
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        sb.append(" can't be regenerated");
        if (!this.duration.toString().isEmpty()) {
            if (this.duration == Duration.EndOfTurn) {
                sb.append(" this turn");
            } else {
                sb.append(' ').append(this.duration.toString());
            }
        }
        return sb.toString();
    }
}

