/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;

public class ChooseNewTargetsTargetEffect
extends OneShotEffect {
    private final boolean forceChange;
    private final boolean onlyOneTarget;

    public ChooseNewTargetsTargetEffect() {
        this(false, false);
    }

    public ChooseNewTargetsTargetEffect(boolean forceChange, boolean onlyOneTarget) {
        super(Outcome.Benefit);
        this.forceChange = forceChange;
        this.onlyOneTarget = onlyOneTarget;
    }

    protected ChooseNewTargetsTargetEffect(ChooseNewTargetsTargetEffect effect) {
        super(effect);
        this.forceChange = effect.forceChange;
        this.onlyOneTarget = effect.onlyOneTarget;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            StackObject stackObject = game.getStack().getStackObject(targetId);
            if (stackObject == null) continue;
            stackObject.chooseNewTargets(game, source.getControllerId(), this.forceChange, this.onlyOneTarget, null);
        }
        return true;
    }

    @Override
    public ChooseNewTargetsTargetEffect copy() {
        return new ChooseNewTargetsTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        if (this.forceChange) {
            sb.append("change the target of ");
        } else {
            sb.append("you may choose new targets for ");
        }
        sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "it"));
        return sb.toString();
    }
}

