/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class ConjureCardEffect
extends OneShotEffect {
    private final String cardName;
    private final Zone zone;
    private final int amount;

    public ConjureCardEffect(String cardName) {
        this(cardName, Zone.HAND, 1);
    }

    public ConjureCardEffect(String cardName, Zone zone, int amount) {
        super(Outcome.Benefit);
        this.cardName = cardName;
        this.zone = zone;
        this.amount = amount;
    }

    private ConjureCardEffect(ConjureCardEffect effect) {
        super(effect);
        this.cardName = effect.cardName;
        this.zone = effect.zone;
        this.amount = effect.amount;
    }

    @Override
    public ConjureCardEffect copy() {
        return new ConjureCardEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardInfo cardInfo = CardRepository.instance.findCards(new CardCriteria().name(this.cardName)).stream().findFirst().orElse(null);
        if (cardInfo == null) {
            return false;
        }
        HashSet<Card> cards = new HashSet<Card>();
        for (int i = 0; i < this.amount; ++i) {
            Card card = cardInfo.createCard();
            cards.add(card);
        }
        game.loadCards(cards, source.getControllerId());
        return player.moveCards(cards, this.zone, source, game);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("conjure ");
        sb.append(CardUtil.numberToText(this.amount, "a"));
        sb.append(' ');
        sb.append("card");
        sb.append(this.amount > 1 ? "s " : " ");
        sb.append("named ");
        sb.append(this.cardName);
        sb.append(' ');
        switch (this.zone) {
            case HAND: 
            case GRAVEYARD: 
            case LIBRARY: {
                sb.append("into your");
                break;
            }
            case BATTLEFIELD: {
                sb.append("onto the");
            }
        }
        sb.append(' ');
        sb.append(this.zone.toString().toLowerCase());
        return sb.toString();
    }
}

