/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;

public class CopyTokenEffect
extends ContinuousEffectImpl {
    protected Token token;

    public CopyTokenEffect(Token token) {
        super(Duration.WhileOnBattlefield, Layer.CopyEffects_1, SubLayer.CopyEffects_1a, Outcome.BecomeCreature);
        this.token = token.copy();
        this.staticText = "You may have {this} enter the battlefield as a copy of " + token.getDescription() + " on the battlefield";
    }

    protected CopyTokenEffect(CopyTokenEffect effect) {
        super(effect);
        this.token = effect.token.copy();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        permanent.setName(this.token.getName());
        permanent.getColor(game).setColor(this.token.getColor(game));
        permanent.removeAllCardTypes(game);
        for (CardType cardType : this.token.getCardType(game)) {
            permanent.addCardType(game, cardType);
        }
        permanent.removeAllSubTypes(game);
        permanent.copySubTypesFrom(game, this.token);
        permanent.removeAllSuperTypes(game);
        for (SuperType superType : this.token.getSuperType(game)) {
            permanent.addSuperType(game, superType);
        }
        permanent.getAbilities().clear();
        for (Ability ability : this.token.getAbilities()) {
            permanent.addAbility(ability, source.getSourceId(), game, true);
        }
        permanent.getPower().setModifiedBaseValue(this.token.getPower().getModifiedBaseValue());
        permanent.getToughness().setModifiedBaseValue(this.token.getToughness().getModifiedBaseValue());
        return true;
    }

    @Override
    public CopyTokenEffect copy() {
        return new CopyTokenEffect(this);
    }
}

