/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.util.CardUtil;

public class CreateTokenControllerTargetEffect
extends OneShotEffect {
    private final Token token;
    private final DynamicValue amount;
    private final boolean tapped;

    public CreateTokenControllerTargetEffect(Token token) {
        this(token, 1, false);
    }

    public CreateTokenControllerTargetEffect(Token token, int amount, boolean tapped) {
        this(token, StaticValue.get(amount), tapped);
    }

    public CreateTokenControllerTargetEffect(Token token, DynamicValue amount, boolean tapped) {
        super(Outcome.Neutral);
        this.token = token;
        this.amount = amount.copy();
        this.tapped = tapped;
        this.staticText = this.makeText();
    }

    protected CreateTokenControllerTargetEffect(CreateTokenControllerTargetEffect effect) {
        super(effect);
        this.token = effect.token.copy();
        this.amount = effect.amount.copy();
        this.tapped = effect.tapped;
    }

    @Override
    public CreateTokenControllerTargetEffect copy() {
        return new CreateTokenControllerTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controllerOfTarget = this.getTargetPointer().getControllerOfFirstTargetOrLKI(game, source);
        if (controllerOfTarget != null) {
            int value = this.amount.calculate(game, source, this);
            return this.token.putOntoBattlefield(value, game, source, controllerOfTarget.getId(), this.tapped, false);
        }
        return false;
    }

    private String makeText() {
        String text = "Its controller creates ";
        if (this.token.getDescription().contains(", a legendary")) {
            text = text + this.token.getDescription();
            return text;
        }
        if (this.amount.toString().equals("1")) {
            text = this.tapped ? text + "a tapped " + this.token.getDescription() : text + CardUtil.addArticle(this.token.getDescription());
        } else {
            text = text + CardUtil.numberToText(this.amount.toString()) + " ";
            if (this.tapped) {
                text = text + "tapped ";
            }
            text = text + this.token.getDescription().replace("token. It has", "tokens. They have");
            if (this.token.getDescription().endsWith("token")) {
                text = text + "s";
            }
            text = text.replace("token ", "tokens ");
        }
        String message = this.amount.getMessage();
        if (!message.isEmpty()) {
            text = this.amount.toString().equals("X") ? text + ", where X is " : text + " for each ";
        }
        text = text + message;
        return text;
    }
}

