/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class DamageSelfEffect
extends OneShotEffect {
    protected int amount;

    public DamageSelfEffect(int amount) {
        super(Outcome.Damage);
        this.amount = amount;
    }

    protected DamageSelfEffect(DamageSelfEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public DamageSelfEffect copy() {
        return new DamageSelfEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.damage(this.amount, source.getSourceId(), source, game, false, true);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{this} deals ").append(this.amount).append(" damage to itself");
        return sb.toString();
    }
}

