/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.TurnMod;

class DelayedAddMainPhaseAbility
extends DelayedTriggeredAbility {
    private UUID connectedTurnMod;
    private boolean enabled;

    public DelayedAddMainPhaseAbility() {
        super(null, Duration.EndOfTurn);
        this.usesStack = false;
    }

    public DelayedAddMainPhaseAbility(DelayedAddMainPhaseAbility ability) {
        super(ability);
        this.connectedTurnMod = ability.connectedTurnMod;
        this.enabled = ability.enabled;
    }

    @Override
    public DelayedAddMainPhaseAbility copy() {
        return new DelayedAddMainPhaseAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PHASE_CHANGED || event.getType() == GameEvent.EventType.COMBAT_PHASE_PRE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.PHASE_CHANGED && this.connectedTurnMod.equals(event.getSourceId())) {
            this.enabled = true;
        }
        if (event.getType() == GameEvent.EventType.COMBAT_PHASE_PRE && this.enabled) {
            game.getState().getTurnMods().add(new TurnMod(this.getControllerId()).withExtraPhase(TurnPhase.POSTCOMBAT_MAIN));
            this.enabled = false;
        }
        return false;
    }

    public void setConnectedTurnMod(UUID connectedTurnMod) {
        this.connectedTurnMod = connectedTurnMod;
    }

    @Override
    public String getRule() {
        return "add additional post combat main phase";
    }
}

