/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class DestroyAttachedToEffect
extends OneShotEffect {
    private final boolean noRegen;

    public DestroyAttachedToEffect(String description) {
        this(description, false);
    }

    public DestroyAttachedToEffect(String description, boolean noRegen) {
        super(Outcome.DestroyPermanent);
        this.noRegen = noRegen;
        this.staticText = "destroy " + description;
        if (noRegen) {
            this.staticText = this.staticText + ". It can't be regenerated";
        }
    }

    protected DestroyAttachedToEffect(DestroyAttachedToEffect effect) {
        super(effect);
        this.noRegen = effect.noRegen;
    }

    @Override
    public DestroyAttachedToEffect copy() {
        return new DestroyAttachedToEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent attachedTo;
        Permanent attachment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (attachment != null && attachment.getAttachedTo() != null && (attachedTo = game.getPermanent(attachment.getAttachedTo())) != null) {
            return attachedTo.destroy(source, game, this.noRegen);
        }
        return false;
    }
}

