/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.Step;
import mage.target.targetpointer.FixedTarget;

class DetainAllRestrictionEffect
extends RestrictionEffect {
    private final List<FixedTarget> detainedObjects;

    public DetainAllRestrictionEffect(List<FixedTarget> detainedObjects) {
        super(Duration.Custom);
        this.detainedObjects = detainedObjects;
        this.staticText = "";
    }

    protected DetainAllRestrictionEffect(DetainAllRestrictionEffect effect) {
        super(effect);
        this.detainedObjects = effect.detainedObjects;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        for (FixedTarget fixedTarget : this.detainedObjects) {
            Permanent permanent = game.getPermanent(fixedTarget.getFirst(game, source));
            if (permanent == null) continue;
            permanent.addInfo("detain" + this.getId(), "[Detained]", game);
        }
    }

    @Override
    public boolean isInactive(Ability source, Game game) {
        if (game.getPhase().getStep().getType() == PhaseStep.UNTAP && game.getStep().getStepPart() == Step.StepPart.PRE && (game.isActivePlayer(source.getControllerId()) || game.getPlayer(source.getControllerId()).hasReachedNextTurnAfterLeaving())) {
            for (FixedTarget fixedTarget : this.detainedObjects) {
                Permanent permanent = game.getPermanent(fixedTarget.getFirst(game, source));
                if (permanent == null) continue;
                permanent.addInfo("detain" + this.getId(), "", game);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        for (FixedTarget fixedTarget : this.detainedObjects) {
            UUID targetId = fixedTarget.getFirst(game, source);
            if (targetId == null || !targetId.equals(permanent.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public DetainAllRestrictionEffect copy() {
        return new DetainAllRestrictionEffect(this);
    }
}

