/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

public class DoIfClashWonEffect
extends OneShotEffect {
    protected final Effect executingEffect;
    private final boolean setTargetPointerToClashedOpponent;

    public DoIfClashWonEffect(Effect effect) {
        this(effect, false);
    }

    public DoIfClashWonEffect(Effect effect, boolean setTargetPointerToClashedOpponent) {
        super(Outcome.Benefit);
        this.executingEffect = effect;
        this.setTargetPointerToClashedOpponent = setTargetPointerToClashedOpponent;
    }

    protected DoIfClashWonEffect(DoIfClashWonEffect effect) {
        super(effect);
        this.executingEffect = effect.executingEffect.copy();
        this.setTargetPointerToClashedOpponent = effect.setTargetPointerToClashedOpponent;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (player == null || mageObject == null) {
            return false;
        }
        if (new ClashEffect().apply(game, source)) {
            if (this.setTargetPointerToClashedOpponent) {
                Player opponent = game.getPlayer((UUID)this.getValue("clashOpponent"));
                if (opponent != null) {
                    this.executingEffect.setTargetPointer(new FixedTarget(opponent.getId()));
                }
            } else {
                this.executingEffect.setTargetPointer(this.getTargetPointer().copy());
            }
            if (this.executingEffect instanceof OneShotEffect) {
                return this.executingEffect.apply(game, source);
            }
            game.addEffect((ContinuousEffect)this.executingEffect, source);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (!this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "clash with an opponent. If you win, " + this.executingEffect.getText(mode);
    }

    @Override
    public DoIfClashWonEffect copy() {
        return new DoIfClashWonEffect(this);
    }
}

