/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class DontUntapInControllersUntapStepTargetEffect
extends ContinuousRuleModifyingEffectImpl {
    private final String targetName;

    public DontUntapInControllersUntapStepTargetEffect(Duration duration) {
        this(duration, "That creature");
    }

    public DontUntapInControllersUntapStepTargetEffect(Duration duration, String targetName) {
        super(duration, Outcome.Detriment);
        this.targetName = targetName;
    }

    protected DontUntapInControllersUntapStepTargetEffect(DontUntapInControllersUntapStepTargetEffect effect) {
        super(effect);
        this.targetName = effect.targetName;
    }

    @Override
    public DontUntapInControllersUntapStepTargetEffect copy() {
        return new DontUntapInControllersUntapStepTargetEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getTurnStepType() != PhaseStep.UNTAP) {
            return false;
        }
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent;
            if (!event.getTargetId().equals(targetId) || (permanent = game.getPermanent(targetId)) == null || !game.isActivePlayer(permanent.getControllerId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.targetName + " doesn't untap during its controller's untap step" + (this.getDuration().toString().isEmpty() ? "" : " ") + (Object)((Object)this.getDuration());
    }
}

