/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class DontUntapInPlayersNextUntapStepAllEffect
extends ContinuousRuleModifyingEffectImpl {
    private int validForTurnNum;
    FilterPermanent filter;

    public DontUntapInPlayersNextUntapStepAllEffect(FilterPermanent filter) {
        super(Duration.Custom, Outcome.Detriment, false, true);
        this.filter = filter;
    }

    protected DontUntapInPlayersNextUntapStepAllEffect(DontUntapInPlayersNextUntapStepAllEffect effect) {
        super(effect);
        this.validForTurnNum = effect.validForTurnNum;
        this.filter = effect.filter;
    }

    @Override
    public DontUntapInPlayersNextUntapStepAllEffect copy() {
        return new DontUntapInPlayersNextUntapStepAllEffect(this);
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        Permanent permanentToUntap = game.getPermanent(event.getTargetId());
        if (permanentToUntap != null && mageObject != null) {
            return permanentToUntap.getLogName() + " doesn't untap (" + mageObject.getLogName() + ')';
        }
        return null;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP_STEP || event.getType() == GameEvent.EventType.UNTAP;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (this.validForTurnNum > 0 && this.validForTurnNum < game.getTurnNum()) {
            this.discard();
            return false;
        }
        if (event.getType() == GameEvent.EventType.UNTAP_STEP && game.isActivePlayer(this.getTargetPointer().getFirst(game, source))) {
            if (this.validForTurnNum == game.getTurnNum()) {
                this.discard();
                return false;
            }
            this.validForTurnNum = game.getTurnNum();
        }
        if (game.getTurnStepType() == PhaseStep.UNTAP && event.getType() == GameEvent.EventType.UNTAP && (permanent = game.getPermanent(event.getTargetId())) != null) {
            Player controller = game.getPlayer(source.getControllerId());
            if (!permanent.isControlledBy(this.getTargetPointer().getFirst(game, source))) {
                return false;
            }
            if (controller != null && !game.isOpponent(controller, permanent.getControllerId())) {
                return false;
            }
            if (game.isActivePlayer(permanent.getControllerId()) && this.filter.match(permanent, source.getControllerId(), source, game)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (!this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.filter.getMessage() + ' ' + this.getTargetPointer().describeTargets(mode.getTargets(), "target opponent") + " controls don't untap during their next untap step";
    }
}

